Attribute VB_Name = "modMonitor"
Option Explicit
Public Sub GetScanList(io As Agt3494A, lst As ListBox)
    ' get the scan list and fill in the combo box on the toolbar
    Dim strChannelList() As String
    Dim cancel As Boolean
    Dim i As Integer

    On Error Resume Next

    GetScanListArray io, strChannelList, cancel

    If cancel = False Then
        With lst
            .Clear
            .AddItem "Front Panel"
            For i = 0 To UBound(strChannelList)
                lst.AddItem "Channel " & strChannelList(i)
            Next i
            lst.ListIndex = 1
        End With                                           ' monitorCB
    End If
End Sub

Private Sub GetScanListArray(io As Agt3494A, strChannelList() As String, cancel As Boolean)
    ' Returns the scan list as an array of strings
    ' returns cancel as true if there is an error
    Dim channelList() As Byte
    Dim byt As Byte
    Dim count As Long
    Dim ch As String
    Dim i As Long

    On Error GoTo getScanListError

    cancel = False

    io.Output "route:scan?"
    io.Enter channelList, "I1"

    ' create an array of strings for the list of channels
    ReDim strChannelList(150)
    count = 0
    For i = 2 To UBound(channelList) - 1
        byt = channelList(i)
        If byt = 44 Then                                   ' looking for a comma ","
            ch = Chr$(channelList(i - 3)) & Chr(channelList(i - 2)) & Chr(channelList(i - 1))
            strChannelList(count) = ch
            count = count + 1
        End If
    Next i
    i = UBound(channelList)
    ch = Chr$(channelList(i - 3)) & Chr(channelList(i - 2)) & Chr(channelList(i - 1))
    strChannelList(count) = ch

    ReDim Preserve strChannelList(count)

    Exit Sub

getScanListError:
    cancel = True
End Sub
Public Function Monitor(io As Agt3494A, txt As TextBox, ByVal channel As String)
    ' calls the instrument and gets the reading for channel or if
    ' channel is not a channel number uses the channel set on front panel
    Dim reading As Double
    Dim cmd As String
    Dim strTemp As String

    cmd = "Route:Monitor (@" & channel & ")"

    With io
        If IsNumeric(channel) Then
            .Output cmd
            strTemp = "ch " & Str$(channel) & ",  "
        Else
            strTemp = "Front Panel, "
        End If
        .Output "Route:Monitor:State ON"
        .Output "Route:Monitor:Data?"
        .Enter reading
        txt.SelText = strTemp & Str$(reading) & vbCrLf
    End With


End Function
